local super = require "Object"

Overlay = super:new()

local defaults = {
}

local nilDefaults = {
    'name', 'x', 'y',
}

function Overlay:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self._stamp = nil
    self._width = nil
    self._height = nil
    
    return self
end

function Overlay:setName(name)
    self:setProperty('name', name)
end

function Overlay:getName()
    return self:getProperty('name')
end

function Overlay:setPosition(x, y)
    self:setProperty('x', x)
    self:setProperty('y', y)
end

function Overlay:getPosition()
    return self:getProperty('x'), self:getProperty('y')
end

function Overlay:setSize(width, height)
    self._width = width
    self._height = height
end

function Overlay:getSize()
    return self._width, self._height
end

function Overlay:setStamp(stamp)
    self._stamp = stamp
end

function Overlay:getStamp()
    return self._stamp
end

return Overlay
